program BCFileExtract;

uses
  Math, SysUtils;

const
  //DATAFILENAME = 'C:\Programme\Black Chronos\Glow (Demo)\Data.bcp';
  SIGNATURE_BCP = 'BCPF';
  SIGNATURE_OOS = 'OoSD';
  RECSIZE = 1;
  BUFSIZE = 64 * 1024;

var
  Handle, Outfile: File;
  Filename, FilenameOnly, StartMask, EndMask, Signature: string;
  Buffer: array[0..BUFSIZE - 1] of Byte;
  B: Integer;
  Recordcount, I, Position, FLength: Cardinal;

(*
Datentyp OOS (bei Sorades)
Datei 1: Offset    0 (0x00000000),  202 Bytes lang
Datei 2: Offset  202 (0x000000CA), 3126 Bytes lang
Datei 2: Offset 3328 (0x00000D00),    ? Bytes lang
Bei Offset 222319307 [0xD4052CB] steht der erste Dateiname.
Ab da:
52 Byte Dateiname
4 Bytes (CRC?)
4 Bytes Offset vom Dateianfang
4 Bytes Gre
4 Bytes Nullen
= 68 [0x44] Bytes
Am Dateiende - 16 steht 'OoSD'
Am Dateiende - 8 steht die Anzahl der Dateien (2319 Stck)
Dateiende - 16 - Dateianzahl * 68 = Start der Dateinamensliste

Datentyp BCPF (bei Glow)
Datei 1: 10326 [0x2856] Byte
Datei 2: offset: 13758 [0x35BE]
Bei Offset 73533261 [0x462074D] steht der erste Dateiname.
Ab da:
256 Byte Dateiname
4 Byte Position
4 Byte Gre
4 Byte nochmal die Gre?
*)

begin
  if ParamCount >= 1 then
    Filename := ParamStr(1)
  else if FileExists('Data.bcp') then
    Filename := 'Data.bcp'
  else if FileExists('Data.oos') then
    Filename := 'Data.oos';

  if not FileExists(Filename) then
  begin
    Writeln('Error: ' + SIGNATURE_BCP + ' or ' + SIGNATURE_OOS +
      ' data file "' + Filename + '" not found!');
    Writeln('Example: ' + ParamStr(0) + ' data.oos *.ogg');
    Exit;
  end;

  if ParamCount >= 2 then
    StartMask := ParamStr(2);
  I := Pos('*', StartMask);
  if I > 0 then
  begin
    EndMask := Copy(StartMask, I + 1);
    StartMask := Copy(StartMask, 1, I - 1);
  end;
  while Pos('*', EndMask) > 0 do
  begin
    EndMask := Copy(EndMask, Pos('*', EndMask) + 1);
  end;
  if (StartMask <> '') or (EndMask <> '') then
    Writeln('Using file name mask ' + StartMask + '*' + EndMask + '...');

  Assign(Handle, Filename);
  { Hier wird gleichzeitig die Record-Gre fr BlockRead/Write festgelegt. }
  Reset(Handle, RECSIZE);

  Seek(Handle, Filesize(Handle) - 20);
  BlockRead(Handle, Buffer, 20);
  if Buffer[0] = Ord(SIGNATURE_BCP[1]) then
    Signature := Chr(Buffer[0]) + Chr(Buffer[1]) + Chr(Buffer[2]) + Chr(Buffer[3])
  else if Buffer[4] = Ord(SIGNATURE_OOS[1]) then
    Signature := Chr(Buffer[4]) + Chr(Buffer[5]) + Chr(Buffer[6]) + Chr(Buffer[7]);

  if (Signature <> SIGNATURE_BCP) and (Signature <> SIGNATURE_OOS) then
  begin
    Writeln('Error: "' + Filename + '" is not a valid ' + SIGNATURE_BCP + ' or ' +
      SIGNATURE_OOS + ' data file!');
    Exit;
  end;

  Seek(Handle, Filesize(Handle) - 8); //ist bei beiden Typen gleich
  BlockRead(Handle, Recordcount, 4);
  if (Recordcount <= 0) then
  begin
    Writeln('Error: Invalid number of records!');
    Exit;
  end;

  for I := Recordcount downto 1 do
  begin
    if Signature = SIGNATURE_BCP then
    begin
      Seek(Handle, Filesize(Handle) - (I * (256 + 4 + 4 + 4) + 20));
      BlockRead(Handle, Buffer, 256);
      BlockRead(Handle, Position, 4);
      BlockRead(Handle, FLength, 4);
    end
    else
    begin
      Seek(Handle, Filesize(Handle) - (I * 68 + 16));
      BlockRead(Handle, Buffer, 52);
      BlockRead(Handle, Position, 4); //berspringen, das ist wahrscheinlich die CRC
      BlockRead(Handle, Position, 4);
      BlockRead(Handle, FLength, 4);
    end;

    Filename := StringReplace(PChar(@Buffer), '/', '\', [rfReplaceAll]);

    FilenameOnly := ExtractFileName(ExpandFileName(Filename));
    if StartMask <> '' then
      if Copy(FilenameOnly, 0, Length(StartMask)) <> StartMask then
        Continue;
    if EndMask <> '' then
      if Copy(FilenameOnly, Length(FilenameOnly) - Length(EndMask) + 1) <> EndMask then
        Continue;

    Writeln(Copy(Filename, Length(Filename) - 75, 76) + '...');
    ForceDirectories(ExtractFilePath(ExpandFileName(Filename)));
    Assign(Outfile, Filename);
    Rewrite(Outfile, RECSIZE);
    Seek(Handle, Position);
    while (FileSize(Outfile) < FLength) do
    begin
      B := Min(BUFSIZE, Abs(FLength - FileSize(Outfile)));
      BlockRead(Handle, Buffer, B);
      BlockWrite(Outfile, Buffer, B);
    end;
    Close(Outfile);
  end;

  Close(Handle);
end.
